<?php $title = 'Contact Us :: Greenava'; ?>
<?php include 'include/head.php'; ?>
<?php include 'include/header.php'; ?>
<style>
    .error {
        /* font-size: 17px !important; */
        color: red !important;
    }
</style>

    <!-- Banner Section -->
    <section class="banner-outer-section">
        <div class="banner-bg contact-banner-bg"
            style="background-image: url(./assets/images/contact/contact-banner.jpg);">
            <div class="container">
                <div class="banner-inner-section">
                    <div class="banner-content" data-aos="fade-up" data-aos-offset="150">
                        <h2>Contact Us</h2>
                    </div>
                    <div class="banner-image" data-aos="zoom-in" data-aos-duration="1500">
                        <img src="./assets/images/contact/mango_pineapple_contact.png" alt="">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Banner Section -->

    <!-- Form Section  -->
    <section class="form-section">
        <div class="container">
            <div class="form-inner">
                <div class="inner-wrapper">
                    <div class="left-section">
                        <h2 data-aos="fade-up" data-aos-offset="150">Get in touch</h2>
                        <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">
                            If you have any inquiries or just want to know about <br />
                            our services, please fill the form below.</p>
                        <div class="form-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
                            <div class="row">
                                <form action="" id="contactForm" method="post">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <input type="text" name="full_name" class="form-control" placeholder="Full Name">
                                        </div>
                                        <div class="form-group">
                                            <input type="email" name="email" class="form-control" placeholder="Email ID">
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="mobile" class="form-control" placeholder="Mobile No.">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <textarea name="message" class="form-control" placeholder="Message"></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="left-captcha-wrapper">
                                            <div class="g-recaptcha" data-sitekey="6Lcji3gsAAAAAP008hKQKLey3GnQhqNq7wlBbmo5"></div>
                                            <!-- secret key  -->
                                            <!-- 6Le099orAAAAAGwmqCFBtJfeWcbAKHmawOK45sfg  -->
                                            <!-- secret key  -->
                                            <div class="right-submit-button">
                                                <div class="form-group">
                                                    <div class="submit-wrapper">
                                                        <button type="submit" class="submit_btn">Submit</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="right-section">
                        <h2 data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">Quick Connect</h2>
                        <div class="icon-address-wrapper">
                            <div class="icon-text-box" data-aos="fade-up" data-aos-offset="150">
                                <div class="icon-wrapper">
                                    <img src="./assets/images/contact/contact-location-icon.png" alt="">
                                </div>
                                <a href="javascript:void(0);">P.O. Box 2636 - 01000, Thika, Kenya</a>
                            </div>
                            <div class="icon-text-box" data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">
                                <div class="icon-wrapper">
                                    <img src="./assets/images/contact/contact-mail-icon.png" alt="">
                                </div>
                                <a href="mailto:rs@greenavainternational.com">rs@greenavainternational.com</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Form Section  -->

    <!-- Bottom Image Section  -->
    <div class="bottom-image-section">
        <div class="custom-container">
            <div class="bottom-image-inner" data-aos="fade-zoom-in" data-aos-delay="100" data-aos-duration="2000">
                <img src="./assets/images/contact/greenava-contact.jpg" alt="">
            </div>
        </div>
    </div>
    <!-- Bottom Image Section  -->


    <?php include 'include/footer.php'; ?>


    <script type="text/javascript">

        $.validator.addMethod("is_valid_email", function (value, element) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            return regex.test(value);
        }, "Please enter a valid email address");

        $.validator.addMethod('numericOnly', function (value) {
            return /^[0-9]+$/.test(value);
        }, 'Please enter only numeric values');

        $.validator.addMethod('noSpamEmail', function (value, element) {
            var domainJson = $.getJSON({ 'url': "assets/spam_domain.json", 'async': false });
            var bannedDomains = domainJson.responseJSON;
            var domain = value.split('@')[1];
            return bannedDomains.indexOf(domain) < 0;
        }, 'Email from this domain are not allowed');

        $.validator.addMethod("noLinks", function (value, element) {
            var linkRegex1 = /\b(?:https?|ftp):\/\/|www\.[^\s]+/i;
            var linkRegex2 = /\b(?:[a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}\b/;
            return !(linkRegex1.test(value) || linkRegex2.test(value));
        }, "Links are not allowed.");

        $.validator.addMethod("noHtml", function (value, element) {
            var htmlTagRegex = /<\/?[^>]+>/gi;
            return this.optional(element) || !htmlTagRegex.test(value);
        }, "HTML tags are not allowed.");

        $.validator.addMethod("alphaOnly", function (value, element) {
            return this.optional(element) || /^[A-Za-z\s]+$/.test(value);
        }, "Only alphabetic characters are allowed.");

        $("#contactForm").validate({
            ignore: [],

            rules: {
                full_name: {
                    required: true,
                    maxlength: 100,
                    noLinks: true,
                    noHtml: true,
                    alphaOnly: true
                },
                email: {
                    required: true,
                    email: true,
                    is_valid_email: true,
                    noSpamEmail: true
                },
                mobile: {
                    required: true,
                    numericOnly: true,
                    minlength: 10,
                    maxlength: 10,
                },
                "g-recaptcha-response": {
                    required: true,
                },
            },
            messages: {
                full_name: {
                    required: "Enter full name.",
                    maxlength: "First name cannot exceed 50 characters.",
                    noLinks: "Links are not allowed in the first name."
                },
                email: {
                    required: "Enter email",
                    email: "Please enter a valid email address.",
                    is_valid_email: "Please enter a properly formatted email.",
                    noSpamEmail: "Disposable or spammy emails are not allowed."
                },
                mobile: {
                    required: "Enter mobile number.",
                    numericOnly: "Only numbers are allowed.",
                    minlength: "Phone number must be 10 digits.",
                    maxlength: "Phone number must be 10 digits."
                },
                
                "g-recaptcha-response": {
                    required: "Please fill the captcha."
                }
            },
            errorPlacement: function (error, element) {
                if(element.attr("name") === "g-recaptcha-response") {
                    error.insertAfter(element.closest('.g-recaptcha'));
                }
                else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {

                $.ajax({
                    url: "include/send-contact-mail.php",
                    method: "POST",
                    data: $(form).serialize(),
                    dataType: "json",
                    beforeSend: function () {
                        $('.submit_btn').prop("disabled", true).html("<i class='fa fa-circle-o-notch fa-spin'></i> Proccesing...");
                    },
                    success: function (response) {
                        if (response.success == true) {
                            $('#contactForm')[0].reset();
                            sessionStorage.setItem(
                                "thankyou_message",
                                "Thank you for contacting us; we’ll reach out to you shortly."
                            );
                            window.location.href = "thank-you.php";
                            // alert("message sent succefully");
                        } else if (response.success == false) {
                            $('#' + response.errorType).html(response.msg).show();
                        }
                        $('.submit_btn').prop("disabled", false).html("Submit");
                    },
                    error: function (error) {

                        console.error(error);
                    }
                });
                return false;
                console.log("form submited");
            }
        });
    </script>
